<?php

declare(strict_types=1);

require 'InstagramDownloader.php';

header('Content-Type: application/json; charset=utf-8');

if ($_SERVER['REQUEST_METHOD'] !== 'GET' && $_SERVER['REQUEST_METHOD'] !== 'POST') {
    InstagramDownloader::respond(405, [
        'status' => false,
        'error'  => 'method_not_allowed'
    ]);
}

$url = $_POST['url'] ?? $_GET['url'] ?? null;

if (!$url || !filter_var($url, FILTER_VALIDATE_URL)) {
    InstagramDownloader::respond(400, [
        'status' => false,
        'error'  => 'invalid_or_missing_url'
    ]);
}

try {
    $ig = new InstagramDownloader(__DIR__ . '/cookies.txt');

    if (preg_match('~instagram\.com/(p|reel|tv)/~i', $url)) {
        $result = $ig->post($url);
    } elseif (preg_match('~instagram\.com/[^/]+/?$~i', $url)) {
        $result = $ig->profile($url);
    } else {
        InstagramDownloader::respond(400, [
            'status' => false,
            'error'  => 'unsupported_url'
        ]);
    }

    InstagramDownloader::respond(
        $result['status'] ? 200 : 400,
        $result
    );

} catch (Throwable $e) {

    InstagramDownloader::respond(500, [
        'status' => false,
        'error'  => 'server_error'
    ]);
}